
// RESOURCES

datablock SLResourceData(GameResourceData)
{
   // initialize experience
   experienceCount = 0;
   experienceMin = 0;

   // initialize gold
   goldCount = 0;
   goldMin = 0;
   goldMax = 100000;

   // initialize wood
   woodCount = 0;
   woodMin = 0;
   woodMax = 100000;

   // initialize water
   waterCount = 0;
   waterMin = 0;
   waterMax = 0;

   // initialize food
   foodCount = 15;
   foodMin = 0;
   foodMax = 20;

   // initialize people
   peopleCount = 0;
   peopleMin = 0;
   peopleMax = 0;
   peopleLimit = 40;

   // initialize happiness
   happinessCount = 80;
   happinessLowRate = "50 0.5";
   happinessHighRate = "150 1.25";
   
   // production changes based on unique produce buildings (gains)
   produceHappiness = "0 5 5 5 5 5 5 5";
   
   // this sets the population and happiness changes
   addPopulationHappiness = "5 -5";
   addPopulationHappiness = "10 -15";
   addPopulationHappiness = "15 -20";
   addPopulationHappiness = "20 -30";
   addPopulationHappiness = "25 -40";
   addPopulationHappiness = "30 -50";
   addPopulationHappiness = "35 -60";
   addPopulationHappiness = "40 -65";
   addPopulationHappiness = "45 -70";
   addPopulationHappiness = "50 -72";

   // this sets the happiness based on tax changes
   taxHappiness = "-15 -35";
};

////////////////////////////////////////////////////////////////////////////////
//! Checks to see if we have enough resources to create a unit of type
//! \param %type Type of unit to create
//! \retval bool True if the unit can be created, false otherwise
////////////////////////////////////////////////////////////////////////////////
function SLResource::canCreateUnit(%this, %type)
{
   return (%type.goldCost   <= %this.getGold().getCount()  &&
           %type.woodCost   <= %this.getWood().getCount()  &&
           %type.waterCost  <= %this.getWater().getCount() &&
           %type.foodCost   <= %this.getFood().getCount()  &&
           %type.peopleCost <= %this.getPeople().getCount());
}

////////////////////////////////////////////////////////////////////////////////
//! Deducts resource costs of unit type from resource object
//! \param %type Type of unit
////////////////////////////////////////////////////////////////////////////////
function SLResource::deductUnitCost(%this, %type)
{
   // Deduct resources
   %this.getGold().decreaseCount(%type.goldCost);
   %this.getWood().decreaseCount(%type.woodCost);
   %this.getWater().decreaseCount(%type.waterCost);
   %this.getFood().decreaseCount(%type.foodCost);
   %this.getPeople().decreaseCount(%type.peopleCost);
}
//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~~//
